/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker.LegendarySchemeMaker;

import LegendaryCardMaker.LegendaryItem;
import LegendaryCardMaker.LegendarySchemeMaker.SchemeCardType;
import java.io.File;
import java.util.Comparator;

public class SchemeCard
extends LegendaryItem
implements Comparator<SchemeCard>,
Comparable<SchemeCard>,
Cloneable {
    public String name;
    public int cardNameSize;
    public String subCategory = "";
    public int subCategorySize;
    public SchemeCardType cardType;
    public String cardText;
    public int cardTextSize;
    public boolean changed = false;
    public String imagePath;
    public double imageZoom = 1.0;
    public int imageOffsetX = 0;
    public int imageOffsetY = 0;
    public int numberInDeck = 1;

    public String getCardName(String exportDir) {
        int i = 1;
        String filename = String.valueOf(this.cardType.toString().toLowerCase()) + "_" + this.name.replace(" ", "") + "_" + this.subCategory.replace(" ", "") + "_" + i;
        do {
            filename = String.valueOf(this.cardType.toString().toLowerCase()) + "_" + this.name.replace(" ", "") + "_" + this.subCategory.replace(" ", "") + "_" + i;
            ++i;
        } while (new File(String.valueOf(exportDir) + File.separator + filename + ".jpg").exists() || new File(String.valueOf(exportDir) + File.separator + filename + ".png").exists());
        return filename;
    }

    public String generateOutputString() {
        return this.generateOutputString(false);
    }

    public String generateOutputString(boolean fullExport) {
        String str = "";
        str = String.valueOf(str) + "SCHEME;" + this.name + "\n";
        if (this.name != null) {
            str = String.valueOf(str) + "SCNAMESIZE;" + this.cardNameSize + "\n";
        }
        if (this.subCategory != null) {
            str = String.valueOf(str) + "SCSUBNAME;" + this.subCategory.toString() + "\n";
        }
        if (this.name != null) {
            str = String.valueOf(str) + "SCSUBCATSIZE;" + this.subCategorySize + "\n";
        }
        if (this.cardType != null) {
            str = String.valueOf(str) + "SCTYPE;" + this.cardType.toString() + "\n";
        }
        if (this.cardText != null) {
            str = String.valueOf(str) + "SCTEXT;" + this.cardText + "\n";
        }
        if (this.cardText != null) {
            str = String.valueOf(str) + "SCTEXTSIZE;" + this.cardTextSize + "\n";
        }
        if (this.imagePath != null) {
            str = String.valueOf(str) + "SCIMAGEPATH;" + this.imagePath + "\n";
        }
        if (this.imagePath != null) {
            str = String.valueOf(str) + "SCIMAGEZOOM;" + this.imageZoom + "\n";
        }
        if (this.imagePath != null) {
            str = String.valueOf(str) + "SCIMAGEOFFSETX;" + this.imageOffsetX + "\n";
        }
        if (this.imagePath != null) {
            str = String.valueOf(str) + "SCIMAGEOFFSETY;" + this.imageOffsetY + "\n";
        }
        str = String.valueOf(str) + "SCNUMBERINDECK;" + this.numberInDeck + "\n";
        str = String.valueOf(str) + "SCGENERATE;\n";
        return str;
    }

    @Override
    public int compareTo(SchemeCard o) {
        return this.name.compareTo(o.name);
    }

    @Override
    public int compare(SchemeCard o1, SchemeCard o2) {
        return o1.name.compareTo(o2.name);
    }

    public String getTextExportString() {
        String str = "";
        str = String.valueOf(str) + this.cardType.toString() + "\n";
        str = String.valueOf(str) + this.name + " x " + this.numberInDeck + "\n";
        if (this.subCategory != null) {
            str = String.valueOf(str) + this.subCategory + "\n";
        }
        if (this.cardText != null) {
            str = String.valueOf(str) + this.cardText.replace("<k>", "").replace("<r>", "").replace(" <g> ", "\n").replace("</h>", "\n").replace("<h>", "\n");
        }
        str = String.valueOf(str) + "\n";
        return str;
    }

    public SchemeCard getCopy() {
        try {
            return (SchemeCard)this.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

